package jamezo97.clonecraft;


import java.io.File;

import net.minecraftforge.common.Configuration;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;

public class Config {
	
	/**
	 * Instantiates and loads the config file.
	 * @param event
	 */
	public Config(File file){
		load(file);
	}
	/**
	 * Checks to see if the old config exists. And if it does, delete it!
	 * @param file The config file (assuming it is not null and exists)
	 */
	public void checkOldConfig(File file){
		Configuration config = new Configuration(file);
		config.load();
		if(config.hasKey(config.CATEGORY_ITEM, "TestTubeSeperated")){
			Logger.log("Old config file detected. Deleting..");
			file.delete();
		}
	}
	
	public boolean areOwnersEnabled(){
		return OWNERS_ENABLED;
	}
	
	
	public void load(File file){
		if(file != null && file.exists()){checkOldConfig(file);}
		
		Configuration config = new Configuration(file);
		
		config.load();
		ITEM_NEEDLE_ID = config.getItem("NEEDLE_ID", 4830).getInt();
		ITEM_TESTTUBE_ID = config.getItem("TESTTUBE_ID", 4831).getInt();
		ITEM_EMPTYEGG_ID = config.getItem("EMPTYEGG_ID", 4832).getInt();
		ITEM_SPAWNEGG_ID = config.getItem("SPAWNEGG_ID", 4833).getInt();
		ITEM_GENE_ID = config.getItem("GENE_ID", 4834).getInt();
		ITEM_DNADATA_ID = config.getItem("DNADATA_ID", 4835).getInt();
		
		BLOCK_CENTRIFUGE_ID = config.getBlock("CENTRIFUGE_ID", 480).getInt();
		BLOCK_STERILIZER_ID = config.getBlock("STERILIZER_ID", 481).getInt();
		BLOCK_TRANSMOGRIFIER_ID = config.getBlock("TRANSMOGRIFIER_ID", 482).getInt();
		BLOCK_ANTENNA_ID = config.getBlock("ANTENNA_ID", 483).getInt();
		BLOCK_SEQUENCER_ID = config.getBlock("SEQUENCER_ID", 484).getInt();
		BLOCK_GENEEXTRACTOR_ID = config.getBlock("BLOCK_GENEEXTRACTOR_ID", 485).getInt();
		
		OWNERS_ENABLED = config.get("Options", "Owners Enabled", false).getBoolean(false);
		DEBUG_ENABLED = config.get("Options", "Debug Enabled", false).getBoolean(false);
		
//		DEBUG_ENABLED = config.get("Options", "Debug Mode Enabled", false).getBoolean(false);
		config.save();
	}
	
	boolean OWNERS_ENABLED;
	
	boolean DEBUG_ENABLED;
	
	int ITEM_NEEDLE_ID;
	int ITEM_TESTTUBE_ID;
	int ITEM_EMPTYEGG_ID;
	int ITEM_SPAWNEGG_ID;
	int ITEM_GENE_ID;
	int ITEM_DNADATA_ID;
	
	int BLOCK_CENTRIFUGE_ID;
	int BLOCK_STERILIZER_ID;
	int BLOCK_TRANSMOGRIFIER_ID;
	int BLOCK_ANTENNA_ID;
	int BLOCK_SEQUENCER_ID;
	int BLOCK_GENEEXTRACTOR_ID;
}
